#ifdef WIN32

#ifndef MEETINGACCOUNTSDKWRAP_H
#define MEETINGACCOUNTSDKWRAP_H

#include "MeetingSiteImpl.h"
#include "JMMeetingAccountMgr.h"
#include "JMErrorCodeDef.h"


namespace CSFUnified
{
	class MeetingAccountSDKWrap : public IWbxMeetingAccountObserve
    {
    public:
        ~MeetingAccountSDKWrap();
        static MeetingAccountSDKWrap * getInstance();
        
		void start();
		void stop();

		void verifyAccountWithPassword(std::string siteUrl, std::string userName, csf::SecureString userPass);
		void verifyAccountWithSessionTicket(std::string siteUrl, std::string userName, std::string sessionTicket);
        void deleteDefaultAccount();
		void checkSSOSite(std::string siteUrl);
		void checkSSOSiteList(std::list<std::string> siteList);
		int isSSOSite(std::string siteUrl);

		virtual void OnVerifyAccount(bool bSuccess, TWBXMeetingAccountInfo * pAccount, JMErrorCodeDef::EJMMeetingAccountErrorCode eErrCode);
		virtual void OnNoticeActiveAccountChange(bool bExistActiveAccount);
		virtual void OnNoticeSessionTicketRefreshed(const std::wstring& strSessionTicket);
		virtual void OnNoticeInvalidCertInMeetingSite(JMErrorCodeDef::EJMMeetingAccountErrorCode eErrCode);
		virtual void OnCheckSSOSiteListReady();
		virtual void OnCheckSiteSSOFlagReady(const wstring& strSiteUrl, E_WBX_SITE_SSO_FLAG flag);

	private:
        MeetingAccountSDKWrap();
        
    private:
		IWbxMeetingAccountMgr * m_maMgr;
    };
}

#endif

#endif